#include <msp430.h> 
#include "TLC6983DMA.h"
#include "TLC6983.h"
#include "CCSI_Socket.h"
#include "delayTimer.h"

#define CPU_F ((double)3000000)
#define delay_us(x) __delay_cycles((long)(CPU_F*(double)x/1000000.0))

const uint8_t SINGLE_SCREEN = 16;
const uint8_t STACKED_UNITS = 2;

uint8_t dmaTxData[68]; //Stores the data bytes to be sent tlc6983dma.h/ccsi_so
uint8_t dmaRxData[18]; //Stores the data bytes to be received
uint8_t img_R_RGB[SCREEN_SIZE_Y][SCREEN_SIZE_X];
uint8_t img_G_RGB[SCREEN_SIZE_Y][SCREEN_SIZE_X];
uint8_t img_B_RGB[SCREEN_SIZE_Y][SCREEN_SIZE_X];

unsigned int dmaSyncFlag; //timeout flag

/* Function Name: setData
 *
 * Purpose: Set data send buffer.
 *
 * Parameters:
 * data -> The pointer of data send buffer.
 * high, mid, low -> Data bytes, MSB first.
 * bias -> Bias in the date send buffer.
 *
 */
void setData(uint16_t *data, uint16_t high, uint16_t mid, uint16_t low, uint8_t bias){
    data[0 + bias] = high;
    data[1 + bias] = mid;
    data[2 + bias] = low;
}

void sendSRAMandSYNC()
{
    uint16_t data[6] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};//Data send buffer
    uint8_t y_dir = 0; //Loop index
    uint8_t x_dir = 0;
    uint8_t k = 0;

    for(y_dir = 0 ; y_dir < (SINGLE_SCREEN * STACKED_UNITS); y_dir++){
        for(x_dir = 0 ; x_dir < SINGLE_SCREEN ; x_dir++){
            for(k = 0; k < STACKED_UNITS; k++){
                setData(data,
                        lookup_table_B[img_B_RGB[y_dir][x_dir + (SINGLE_SCREEN * k)]][1],   // B
                        lookup_table_G[img_G_RGB[y_dir][x_dir + (SINGLE_SCREEN * k)]][1],   // G
                        lookup_table_R[img_R_RGB[y_dir][x_dir + (SINGLE_SCREEN * k)]][1],   // R
                        k * 3);
            }
            CCSI_write(W_SRAM, data, STACKED_UNITS * 3);
        }
    }
    // For any repeat need to SYNC to keep displaying the frame
    CCSI_write(W_VSYNC, data, 0);
}

void sendSRAMandSYNC_Highlight()
{
    uint16_t data[6] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};//Data send buffer
    uint8_t i = 0;
    uint8_t j = 0;

    for(i = 0 ; i < 16 ; i++){
        for(j = 0 ; j < 16 ; j++){

            CCSI_write_sram();
            //delay_us(100);
        }
    }
    delay_us(1000);
    // For any repeat need to SYNC to keep displaying the frame
    CCSI_write(W_VSYNC, data, 0);
}

/**
 * main.c
 */
int main(void)
 {
    uint16_t data[6] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};//Data send buffer
    uint8_t y_dir = 0; //Loop index
    uint8_t x_dir = 0;
    uint8_t k = 0;
    
    WDTCTL = WDTPW | WDTHOLD;   // stop watchdog timer
    
    __bic_SR_register(GIE); //enable interrupt
    ucsInitial(); //system clock initial
    timerInitial(); //
    spiInitial();
    dmaInitial();
    
    CCSI_write(W_CHIP_INDEX, data, 0);//Write chip index.
    CCSI_write(W_CHIP_INDEX, data, 0);//Write chip index.
    
    setData(data, 0x5001, 0xF06F, 0x8108, 0);//16x 4MHz/2= 20Mhz, 64 sub-periods, totally xxms, about 50Hz
    CCSI_write(W_FC0, data, 3);
    
    setData(data, 0x0045, 0xE252, 0x97F0, 0);
    CCSI_write(W_FC1, data, 3);
    
    setData(data, 0x000D, 0xD033, 0x0000, 0);//
    CCSI_write(W_FC2, data, 3);
    
    setData(data, 0x0012, 0x7F7F, 0x7F00, 0);//
    CCSI_write(W_FC3, data, 3);
    
    setData(data, 0x0007, 0x003F, 0x6001, 0);//
    CCSI_write(W_FC4, data, 3);
    
    // Write black frame - To prevent showing existing frames in LED Driver SRAM
    // Clear MCU SRAM frame
    for(y_dir = 0; y_dir < (SINGLE_SCREEN * STACKED_UNITS); y_dir++){
        for(x_dir = 0; x_dir < SINGLE_SCREEN; x_dir++){
            for(k = 0; k < STACKED_UNITS; k++){
                img_R_RGB[y_dir][x_dir + (SINGLE_SCREEN * k)] = 0x00;
                img_G_RGB[y_dir][x_dir + (SINGLE_SCREEN * k)] = 0x00;
                img_B_RGB[y_dir][x_dir + (SINGLE_SCREEN * k)] = 0x00;
            }
        }
    }
    
    // Send black frame to LED Driver SRAM and SYNC
    sendSRAMandSYNC();
    
    while(1){
        sendSRAMandSYNC_Highlight();
    }
    
    return 0;
}
